org 100h
  mov al,13h

  add dh,al
  mov ds,dx  ; Pos (s16)
  add dh,al
  mov gs,dx  ; Vel
  add dh,al
  mov fs,dx  ; caustics
  push 0xa000
  pop es      ; screen

  cwd  ; dx=0
P int 10h
  mov ax,0x1010 ; set palette: bl=index dh=R=0 ch=G cl=B
  add dx,0x20
  imul cx,dx,4
  mov cl,ch
  inc bl
  jnz P

  xor cx,cx
  xor si,si
I mov [si],bl    ; Pos=0
  mov [gs:si],bl ; Vel=0
  inc si
  loop I

; dx,bp=time si=cx=0
M:

; add a drop every 16 frames
  push dx
  and dh,3
  inc dh
  sub bp,dx
  pop dx
  jnc DINC
  imul di,dx,2
  add word[di],0x1fff
  imul dx,85
  inc dx
DINC:

  pusha


; water ripple
;      2/3
; 1/3 -old  1/3
;      2/3
O:
  mov ax,[si+320]
  add ax,[si-320]
  add ax,ax
  add ax,[si+2]
  add ax,[si-2]
  mov dx,65535/3
  imul dx
  sub dx,[gs:si]
  mov bx,dx
  sar dx,7
  sub bx,dx
  mov [gs:si],bx

  mov di,bx
  sub bx,[si-2]
  sub di,[si-320]
  sar di,2
  imul di,320
  add di,si
  sar bx,2
  inc byte[fs:bx+di]

  inc si
  inc si
  jnz O
  
  push ds
  push gs
  pop ds
  pop gs

  
S:
  mov bx,[si+2]
  mov dx,[si]
  add dx,bx
  shl dx,4

  sub bx,[si]

  sar bx,3
  sub bx,si
  and bx,32      ; back texture

  fs lodsb       ; si+1
  add al,[fs:si]
  shl al,4

  add al,32
  add al,dh
  add al,bl

  mov [es:si],al
  
  xchg al,ah
  add al,ah
  rcr al,1
  mov [es:si-1],al

  inc si
  loop S

CZ:
  mov [fs:si],cl
  inc si
  jnz CZ

  mov dx,0x3da
V in al,dx
  test al,8
  jnz V
W in al,dx
  test al,8
  jz W

  popa

  in al,60h
  dec al
  jnz M

  ret
